IF EXISTS (SELECT 1	FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_VENDAS_DESCONTOS_ARV_MERC]')	AND type IN (N'P',N'PC'))
	DROP PROCEDURE [dbo].[P_PDV_VD_VENDAS_DESCONTOS_ARV_MERC]
GO

CREATE PROCEDURE [dbo].[P_PDV_VD_VENDAS_DESCONTOS_ARV_MERC] (
	 @CD_EMP INT
	,@CD_FILIAL VARCHAR(2500)
	,@DT_INI DATETIME
	,@DT_FIM DATETIME
	,@TP_CUSTO INT
	,@DEVOLUCAO INT
	,@CD_FABRIC VARCHAR(MAX)
	,@CD_ARV_MERC_LINHA VARCHAR(MAX)
	,@TP_RELA INT = 0
	)
AS
SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

BEGIN
	DECLARE @MULTIPLO AS INT

	SET @MULTIPLO = 1

	IF @DEVOLUCAO = 1
	BEGIN
		SET @MULTIPLO = - 1
	END

	CREATE TABLE #TBL_VD (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_VD INT
		,CD_PROD INT
		,CD_IT INT
		,BAIRRO VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,DT_VD DATETIME
		,TIPO_PRODUTO VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,NR_ECF INT
		,CD_CX INT
		,VD_FIDEL VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,CD_VEND INT
		,NM_FUN VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,CARGO VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,VL_COMIS MONEY
		,PERC_COMIS MONEY
		,MATRIC INT
		,VLR_PMC MONEY
		,CD_TRIB_FC VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,TX_ICMS_IT MONEY
		,VLR_DESC_ITENS MONEY
		,VLR_DESC MONEY
		,QT_IT MONEY
		,VLR_LIQ_VD MONEY
		,VLR_VD MONEY
		,VLR_DESC_OFERTA MONEY
		,ORIG_VENDA VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,QT_VENDAS INT
		,VLR_DESC_VERBA MONEY
		,DS_SIGLA VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,DS_TIPO_DESCONTO VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,LISTA_PROD VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,VLR_CUSTO MONEY
		,VLR_MARGEM_BRUTA MONEY
		,PERC_COMI MONEY
		,VLR_COMI MONEY
		,SIT_VD VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,TOT_IT MONEY
		,VLR_PMC_TOTAL MONEY
		,VLR_CUSTO_MEDIO MONEY
		,CD_CARGO INT
		,VLR_CUSTO_GER MONEY
		,VLR_ICMS_VENDA MONEY
		,CD_CLI_PBM INT
		,NR_AUTORIZACAO VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,VLR_REEMBOL MONEY
		,RZ_CLI_PBM VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,CD_CLI INT
		,RZ_CLI VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,CD_CONV INT
		,DS_CONV VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,HR_VD DATETIME
		,VD_PBM VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,TIPO_OFERTA VARCHAR(MAX) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		,CD_CTR_TBL INT
		,PERC_DESC_KIT_OFERTA MONEY
		,CD_SIGLA INT
		,TP_PROD INT
		,PERC_COMISSAO_SERVICO MONEY
		,PIS_COFINS INT
		,MKTPLACE VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
		);

	SELECT CD_EMP
		,CD_FILIAL
		,BAIRRO
	INTO #PRC_FILIAL
	FROM PRC_FILIAL
	WHERE CD_EMP = @CD_EMP
		AND CD_FILIAL IN (
			SELECT ID
			FROM UFD_PRM_IN_STRING(@CD_FILIAL)
			);

	CREATE INDEX #IX__PRC_FILIAL__VENDAS_DESC ON #PRC_FILIAL (
		CD_FILIAL
		,CD_EMP
		)

	SELECT CD_FABRIC
		,NM_FABRIC
	INTO #EST_PROD_FABRIC
	FROM EST_PROD_FABRIC
	WHERE CD_FABRIC IN (
			SELECT ID
			FROM UFD_PRM_IN_STRING(@CD_FABRIC)
			);

	SELECT CD_EMP
		,CD_ARV_MERC_LINHA
		,DS_ARV_MERC_LINHA
	INTO #EST_ARV_MERC_LINHA
	FROM EST_ARV_MERC_LINHA
	WHERE CD_ARV_MERC_LINHA IN (
			SELECT ID
			FROM UFD_PRM_IN_STRING(@CD_ARV_MERC_LINHA)
			)
		AND CD_EMP = @CD_EMP;

	SELECT P.CD_EMP
		,P.CD_PROD
		,P.DS_PROD
		,P.FLAG_PRODUTO_GENERICO
		-- ,P.PIS_COFINS  
		,P.FLAG_PRODUTO_CONTROLADO
		,P.COMPRA_POR_SUPRIMENTO
		,A.CD_ARV_MERC_LINHA
		,DS_ARV_MERC_CATEG
		,DS_ARV_MERC_DEPTO
		,DS_ARV_MERC_AREA_ATEND
		,DS_ARV_MERC_LINHA
		,DS_ARV_MERC_FAMILIA
		,DS_ARV_MERC_MIX
		,DS_ARV_MERC_MTZ_BCG
		,DS_ARV_MERC_PAPEL
		,DS_ARV_MERC_EQUI
		,DS_ARV_MERC_CONSUMO
		,DS_ARV_MERC_CLASSIFICACAO
		,DS_APRES
		,DS_MC
		,NM_FABRIC
		,P.LISTA_PROD
		,P.PERC_COMIS
		,P.NR_NCM
	INTO #TBL_ARV
	FROM EST_PROD P
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON P.CD_EMP = A.CD_EMP
		AND P.CD_PROD = A.CD_PROD
	INNER JOIN #EST_ARV_MERC_LINHA L ON A.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA
		AND A.CD_EMP = L.CD_EMP
	INNER JOIN EST_ARV_MERC_FAMILIA ON A.CD_ARV_MERC_FAMILIA = EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA
		AND A.CD_EMP = EST_ARV_MERC_FAMILIA.CD_EMP
	INNER JOIN EST_ARV_MERC_MIX ON A.CD_ARV_MERC_MIX = EST_ARV_MERC_MIX.CD_ARV_MERC_MIX
		AND A.CD_EMP = EST_ARV_MERC_MIX.CD_EMP
	INNER JOIN EST_ARV_MERC_MTZ_BCG ON A.CD_ARV_MERC_MTZ_BCG = EST_ARV_MERC_MTZ_BCG.CD_ARV_MERC_MTZ_BCG
		AND A.CD_EMP = EST_ARV_MERC_MTZ_BCG.CD_EMP
	INNER JOIN EST_ARV_MERC_PAPEL ON A.CD_ARV_MERC_PAPEL = EST_ARV_MERC_PAPEL.CD_ARV_MERC_PAPEL
		AND A.CD_EMP = EST_ARV_MERC_PAPEL.CD_EMP
	INNER JOIN #EST_PROD_FABRIC F ON P.CD_FABRIC = F.CD_FABRIC
	INNER JOIN EST_ARV_MERC_CATEGORIA ON A.CD_EMP = EST_ARV_MERC_CATEGORIA.CD_EMP
		AND A.CD_ARV_MERC_CATEG = EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG
	INNER JOIN EST_ARV_MERC_DEPTO ON EST_ARV_MERC_CATEGORIA.CD_EMP = EST_ARV_MERC_DEPTO.CD_EMP
		AND EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_DEPTO = EST_ARV_MERC_DEPTO.CD_ARV_MERC_DEPTO
	INNER JOIN EST_ARV_MERC_AREA_ATENDIMENTO ON EST_ARV_MERC_DEPTO.CD_EMP = EST_ARV_MERC_AREA_ATENDIMENTO.CD_EMP
		AND EST_ARV_MERC_DEPTO.CD_ARV_MERC_AREA_ATEND = EST_ARV_MERC_AREA_ATENDIMENTO.CD_ARV_MERC_AREA_ATEND
	INNER JOIN EST_ARV_MERC_EQUIVALENTE ON A.CD_EMP = EST_ARV_MERC_EQUIVALENTE.CD_EMP
		AND A.CD_ARV_MERC_EQUI = EST_ARV_MERC_EQUIVALENTE.CD_ARV_MERC_EQUI
	INNER JOIN DBO.EST_ARV_MERC_APRESENTACAO ON A.CD_EMP = EST_ARV_MERC_APRESENTACAO.CD_EMP
		AND A.CD_APRES = EST_ARV_MERC_APRESENTACAO.CD_APRES
	INNER JOIN DBO.EST_MC ON A.CD_EMP = EST_MC.CD_EMP
		AND A.CD_MC = EST_MC.CD_MC
	INNER JOIN DBO.EST_ARV_MERC_CONSUMO ON A.CD_EMP = EST_ARV_MERC_CONSUMO.CD_EMP
		AND A.CD_ARV_MERC_CONSUMO = EST_ARV_MERC_CONSUMO.CD_ARV_MERC_CONSUMO
	INNER JOIN DBO.EST_ARV_MERC_CLASSIFICACAO ON A.CD_EMP = EST_ARV_MERC_CLASSIFICACAO.CD_EMP
		AND A.CD_ARV_MERC_CLASSIFICACAO = EST_ARV_MERC_CLASSIFICACAO.CD_ARV_MERC_CLASSIFICACAO;

	/*********************************************************************************************************************************/
	CREATE UNIQUE CLUSTERED INDEX IX_#TBL_ARV ON #TBL_ARV (
		CD_EMP
		,CD_PROD
		);

	SELECT C.CD_EMP
		,C.CD_FILIAL
		,C.CD_PROD
		,C.CD_SIGLA
		,C.TP_PROD
		,C.PERC_COMISSAO_SERVICO
	INTO #TBL_PROD_CPL
	FROM #TBL_ARV V
	INNER JOIN EST_PROD_CPL C ON V.CD_EMP = C.CD_EMP
		AND V.CD_PROD = C.CD_PROD
	WHERE C.CD_EMP = 1
		AND C.CD_FILIAL IN (
			SELECT CD_FILIAL
			FROM #PRC_FILIAL
			);

	CREATE UNIQUE CLUSTERED INDEX IX_#TBL_PROD_CPL ON #TBL_PROD_CPL (
		CD_PROD
		,CD_FILIAL
		,CD_EMP
		);

	CREATE NONCLUSTERED INDEX IX_#TBL_PROD_CPL_CD_EMP ON [DBO].[#TBL_PROD_CPL] ([CD_EMP]) INCLUDE (
		[CD_SIGLA]
		,[TP_PROD]
		)

	/*********************************************************************************************************************************/
	SELECT A.CD_EMP
		,A.CD_FILIAL
		,A.CD_VD
		,1 TP_VD
	INTO #PDV_VD_G
	FROM PDV_VD A
	WHERE A.CD_EMP = 1
		AND A.CD_FILIAL IN (
			SELECT CD_FILIAL
			FROM #PRC_FILIAL
			)
		AND A.DT_VD BETWEEN @DT_INI
			AND @DT_FIM
		AND A.ST_VD = 0;

	CREATE UNIQUE CLUSTERED INDEX IX_#PDV_VD_G ON #PDV_VD_G (
		CD_EMP
		,CD_FILIAL
		,CD_VD
		,TP_VD
		);

	/*********************************************************************************************************************************/
	-- Tag #I001
	-- MODIFICAO FEITA PARA REALIZAO DO CURSOR QUANDO FOR ACRESCENTADO MAIS DE UMA FILIAL A EXECUAO DA PRCEDURE.  
	-- ACRESCENTADO FILTRO DE FILIAL PARA A MELHORIA DE PERFERMANCE DO RELATRIO   
	DECLARE @CD_FILIAL_PAR INT;

	DECLARE TBL_VD_INSERT CURSOR FAST_FORWARD
	FOR
	SELECT CD_FILIAL
	FROM PRC_FILIAL
	WHERE CD_EMP = 1
		AND CD_FILIAL IN (
			SELECT ID
			FROM UFD_PRM_IN_STRING(@CD_FILIAL)
			);

	OPEN TBL_VD_INSERT;

	FETCH NEXT
	FROM TBL_VD_INSERT
	INTO @CD_FILIAL_PAR;

	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #TBL_VD
		SELECT IT.CD_EMP
			,IT.CD_FILIAL
			,IT.CD_VD
			,IT.CD_PROD
			,IT.CD_IT
			,F.BAIRRO
			,IT.DT_VD
			,'REVENDA' AS TIPO_PRODUTO
			,VD.NR_ECF
			,VD.CD_CX
			,CASE 
				WHEN RF.CD_EMP IS NULL
					THEN 'SEM CARTO FIDELIDADE'
				ELSE 'CARTO FIDELIDADE'
				END AS VD_FIDEL
			,ISNULL(IT.CD_VEND, 0) AS CD_VEND
			,ISNULL(FP_FUNC.NM_FUN, 'NAO DEFINIDO') AS NM_FUN
			,ISNULL(FP_CARGO.DS_CARGO, '') AS CARGO
			,ROUND((IT.TOT_IT * ISNULL(IT.PERC_COMIS, 0)) / 100, 4) AS VL_COMIS
			,ISNULL(IT.PERC_COMIS, 0) AS PERC_COMIS
			,ISNULL(FP_FUNC.MATRIC, '') AS MATRIC
			,ISNULL(IT.VLR_PMC, 0) * IT.QT_IT AS VLR_PMC
			,IT.CD_TRIB_FC
			,IT.TX_ICMS_IT
			,ROUND(COALESCE(IT.VLR_DESC, IT.QT_IT * IT.VLR_IT * IT.TX_DESC / 100), 2) - IT.VLR_DESC_VERBA AS VLR_DESC_ITENS
			,IT.VLR_DESC_TOT_RAT AS VLR_DESC
			,IT.QT_IT AS QT_IT
			,CASE 
				WHEN (IT.TOT_IT - IT.VLR_DESC_TOT_RAT) > 0
					THEN IT.TOT_IT - IT.VLR_DESC_TOT_RAT
				ELSE 0
				END AS VLR_LIQ_VD
			,IT.QT_IT * IT.VLR_IT AS VLR_VD
			,CASE 
				WHEN ISNULL(IT.VLR_PMC, 0) > IT.VLR_IT
					THEN (IT.VLR_PMC - IT.VLR_IT) * IT.QT_IT
				ELSE 0
				END AS VLR_DESC_OFERTA
			,CASE 
				WHEN VD.NR_PED_TELEVD > 0
					THEN 'TELEVENDAS'
				ELSE CASE 
						WHEN VD.NR_ORC = 0
							THEN 'DIRETO P.D.V'
						ELSE CASE 
								WHEN ISNULL(VD.ORIG_ORC, 0) = 0
									THEN 'ORCAMENTO'
								WHEN VD.ORIG_ORC = 1
									THEN 'TELEVENDAS'
								WHEN VD.ORIG_ORC = 2
									THEN 'PBM'
								WHEN VD.ORIG_ORC = 3
									THEN 'DRIVE THRU'
								END
						END
				END AS ORIG_VENDA
			,0 AS QT_VENDAS
			,ISNULL(IT.VLR_DESC_VERBA, 0) AS VLR_DESC_VERBA
			,'D ' AS DS_SIGLA
			,GLB_TP_DESCONTO.DS_TP_DESCONTO AS DS_TIPO_DESCONTO
			,CASE 
				WHEN IT.LISTA_PROD = 0
					THEN 'POSITIVA'
				WHEN IT.LISTA_PROD = 1
					THEN 'NEGATIVA'
				WHEN IT.LISTA_PROD = 2
					THEN 'NEUTRA'
				ELSE 'NAO USA LISTA'
				END AS LISTA_PROD
			,CASE 
				WHEN @TP_CUSTO = 0
					THEN IT.QT_IT * IT.VLR_CUSTO
				WHEN @TP_CUSTO = 1
					THEN IT.QT_IT * IT.VLR_CUSTO_MEDIO
				WHEN @TP_CUSTO = 2
					THEN IT.QT_IT * IT.VLR_CUSTO_GER
				ELSE 0
				END AS VLR_CUSTO
			,
			--,CAST(0 AS MONEY)                                          VLR_MARGEM_BRUTA  
			CASE 
				WHEN @TP_CUSTO = 0
					THEN IT.TOT_IT - (IT.QT_IT * IT.VLR_CUSTO)
				WHEN @TP_CUSTO = 1
					THEN IT.TOT_IT - (IT.QT_IT * IT.VLR_CUSTO_MEDIO)
				WHEN @TP_CUSTO = 2
					THEN IT.TOT_IT - (IT.QT_IT * IT.VLR_CUSTO_GER)
				ELSE 0
				END AS VLR_MARGEM_BRUTA
			,IT.PERC_COMI AS PERC_COMI
			,IT.VLR_COMISSAO_FABRIC AS VLR_COMI
			,'NORMAL' AS SIT_VD
			,IT.TOT_IT AS TOT_IT
			,ISNULL(IT.VLR_PMC, 0) * IT.QT_IT AS VLR_PMC_TOTAL
			,ISNULL(IT.VLR_CUSTO_MEDIO, 0) AS VLR_CUSTO_MEDIO
			,FP_FUNC.CD_CARGO AS CD_CARGO
			,ISNULL(IT.VLR_CUSTO_GER, 0) AS VLR_CUSTO_GER
			,CASE 
				WHEN IT.TX_RED_IT > 0
					THEN IT.TOT_IT * (TX_ICMS_IT * TX_RED_IT / 100) / 100
				ELSE (IT.TOT_IT * (IT.TX_ICMS_IT / 100))
				END AS VLR_ICMS_VENDA
			,0 AS CD_CLI_PBM
			,'' AS NR_AUTORIZACAO
			,CONVERT(MONEY, 0) AS VLR_REEMBOL
			,CONVERT(VARCHAR(250), '') AS RZ_CLI_PBM
			,VD.CD_CLI AS CD_CLI
			,RC_CLI.RZ_CLI AS RZ_CLI
			,VD.CD_CONV AS CD_CONV
			,RC_CLI_CONV.DS_CONV AS DS_CONV
			,CONVERT(TIME, VD.HR_VD) AS HR_VD
			,'NAO' AS VD_PBM
			,CASE COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.TIPO_OFERTA, - 1)
				WHEN 0
					THEN 'DESCONTO POR QUANTIDADE'
				WHEN 1
					THEN 'LEVE X PAGUE Y'
				WHEN 2
					THEN 'LEVE X E GANHE Y'
				ELSE 'NAO DEFINIDO'
				END AS TIPO_OFERTA
			,COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.CD_CTR_TBL, 0) AS CD_CTR_TBL
			,COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.PERC_DESC, 0) AS PERC_DESC_KIT_OFERTA
			,C.CD_SIGLA
			,C.TP_PROD
			,IT.PERC_COMISSAO_SERVICO
			,IT.PIS_COFINS
			,'' AS MKTPLACE
		--INTO   #TBL_VD  
		FROM #PDV_VD_G TT
		INNER JOIN PDV_VD VD ON VD.CD_EMP = TT.CD_EMP
			AND VD.CD_FILIAL = TT.CD_FILIAL
			AND VD.CD_VD = TT.CD_VD
		INNER JOIN PDV_VD_IT IT ON VD.CD_EMP = IT.CD_EMP
			AND VD.CD_FILIAL = IT.CD_FILIAL
			AND VD.CD_VD = IT.CD_VD
			AND VD.DT_VD = IT.DT_VD
		LEFT OUTER JOIN GLB_TP_DESCONTO ON IT.TIPO_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO
		INNER JOIN #TBL_PROD_CPL C ON IT.CD_EMP = C.CD_EMP
			AND IT.CD_FILIAL = C.CD_FILIAL
			AND IT.CD_PROD = C.CD_PROD
		INNER JOIN #PRC_FILIAL F ON VD.CD_EMP = F.CD_EMP
			AND VD.CD_FILIAL = F.CD_FILIAL
		LEFT OUTER JOIN FP_FUNC ON IT.CD_EMP = FP_FUNC.CD_EMP
			AND IT.CD_VEND = FP_FUNC.CD_FUN
		LEFT OUTER JOIN FP_CARGO ON FP_FUNC.CD_EMP = FP_CARGO.CD_EMP
			AND FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
		INNER JOIN RC_CLI ON RC_CLI.CD_EMP = VD.CD_EMP
			AND RC_CLI.CD_CLI = VD.CD_CLI
		LEFT JOIN (
			SELECT DISTINCT RF.CD_EMP
				,RF.CD_CLI
			FROM RC_CLI_FIDELI_CARTAO RF
			) RF ON RC_CLI.CD_EMP = RF.CD_EMP
			AND RC_CLI.CD_CLI = RF.CD_CLI
		LEFT JOIN RC_CLI_CONV ON VD.CD_EMP = RC_CLI_CONV.CD_EMP
			AND VD.CD_CONV = RC_CLI_CONV.CD_CONV
		LEFT JOIN V_PDV_VD_IT_DESC_KIT_OFERTA ON IT.CD_EMP = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_EMP
			AND IT.CD_FILIAL = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_FILIAL
			AND IT.CD_VD = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_VD
			AND IT.CD_IT = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_IT
		WHERE IT.CD_EMP = 1
			AND TT.CD_FILIAL = @CD_FILIAL_PAR
			AND IT.DT_VD BETWEEN @DT_INI
				AND @DT_FIM
			AND IT.ST_IT = 1;

		FETCH NEXT
		FROM TBL_VD_INSERT
		INTO @CD_FILIAL_PAR;
	END;

	--FECHANDO CURSOS  
	CLOSE TBL_VD_INSERT;

	--DESALOCANDO CURSOS DA MEMORIA  
	DEALLOCATE TBL_VD_INSERT;

	/*********************************************************************************************************************************/
	INSERT INTO #PDV_VD_G
	SELECT A.CD_EMP
		,A.CD_FILIAL
		,A.CD_NF AS CD_VD
		,2 TP_VD
	FROM EST_NF_SAI_VENDAS A
	JOIN EST_NF_SAI S ON S.CD_EMP = A.CD_EMP
		AND S.CD_FILIAL = A.CD_FILIAL
		AND S.CD_NF = A.CD_NF
	WHERE S.CD_EMP = 1
		AND A.CD_FILIAL IN (
			SELECT CD_FILIAL
			FROM #PRC_FILIAL
			)
		AND S.DT_EMI_NF BETWEEN @DT_INI
			AND @DT_FIM
		AND S.STS_NF = 0;

	/*********************************************************************************************************************************/
	IF EXISTS (
			SELECT *
			FROM #PDV_VD_G
			WHERE TP_VD = 2
			)
	BEGIN
		INSERT INTO #TBL_VD
		SELECT IT.CD_EMP
			,IT.CD_FILIAL
			,IT.CD_NF AS CD_VD
			,IT.CD_PROD
			,IT.CD_IT
			,F.BAIRRO
			,IT.DT_EMI_NF DT_VD
			,'REVENDA' AS TIPO_PRODUTO
			,VD.NF_NF NR_ECF
			,0 CD_CX
			,CASE 
				WHEN RF.CD_EMP IS NULL
					THEN 'SEM CARTO FIDELIDADE'
				ELSE 'CARTO FIDELIDADE'
				END AS VD_FIDEL
			,ISNULL(VD.CD_VEND, 0) AS CD_VEND
			,ISNULL(FP_FUNC.NM_FUN, 'NAO DEFINIDO') AS NM_FUN
			,ISNULL(FP_CARGO.DS_CARGO, '') AS CARGO
			,ROUND(((IT.VLR_TOT_IT - IT.VLR_DESC_IT) * ISNULL(IT.PERC_COMI, 0)) / 100, 4) AS VL_COMIS
			,ISNULL(IT.PERC_COMI, 0) AS PERC_COMIS
			,ISNULL(FP_FUNC.MATRIC, '') AS MATRIC
			,ISNULL(IT.VLR_IT, 0) * IT.QT_IT AS VLR_PMC
			,T.CD_TRIB_FC
			,IT.ALIQ_ICMS TX_ICMS_IT
			,ISNULL(IT.VLR_DESC_IT, 0) AS VLR_DESC_ITENS
			,0 AS VLR_DESC
			,IT.QT_IT AS QT_IT
			,IT.VLR_TOT_IT - IT.VLR_DESC_IT AS VLR_LIQ_VD
			,IT.QT_IT * IT.VLR_IT AS VLR_VD
			,0 AS VLR_DESC_OFERTA
			,'NOTA FISCAL VENDA' AS ORIG_VENDA
			,0 AS QT_VENDAS
			,0 AS VLR_DESC_VERBA
			,'D ' AS DS_SIGLA
			,'NAO DEFINIDO' AS DS_TIPO_DESCONTO
			,CASE 
				WHEN IT.LISTA_PROD = 0
					THEN 'POSITIVA'
				WHEN IT.LISTA_PROD = 1
					THEN 'NEGATIVA'
				WHEN IT.LISTA_PROD = 2
					THEN 'NEUTRA'
				ELSE 'NAO USA LISTA'
				END AS LISTA_PROD
			,CASE 
				WHEN @TP_CUSTO = 0
					THEN IT.QT_IT * IT.VLR_CUSTO
				WHEN @TP_CUSTO = 1
					THEN IT.QT_IT * IT.VLR_CUSTO_MD
				WHEN @TP_CUSTO = 2
					THEN IT.QT_IT * IT.VLR_CUSTO_GERENCIAL_TRANSF
				ELSE 0
				END AS VLR_CUSTO
			--,CAST(0 AS MONEY)                                          VLR_MARGEM_BRUTA  
			,CASE 
				WHEN @TP_CUSTO = 0
					THEN (IT.VLR_TOT_IT - IT.VLR_DESC_IT) - (IT.QT_IT * IT.VLR_CUSTO)
				WHEN @TP_CUSTO = 1
					THEN (IT.VLR_TOT_IT - IT.VLR_DESC_IT) - (IT.QT_IT * IT.VLR_CUSTO_MD)
				WHEN @TP_CUSTO = 2
					THEN (IT.VLR_TOT_IT - IT.VLR_DESC_IT) - (IT.QT_IT * IT.VLR_CUSTO_GERENCIAL_TRANSF)
				ELSE 0
				END AS VLR_MARGEM_BRUTA
			,IT.PERC_COMI AS PERC_COMI
			,IT.VLR_COMISSAO_FABRIC AS VLR_COMI
			,'NORMAL' AS SIT_VD
			,(IT.VLR_TOT_IT - IT.VLR_DESC_IT) AS TOT_IT
			,ISNULL(IT.VLR_PMC, 0) * IT.QT_IT AS VLR_PMC_TOTAL
			,ISNULL(IT.VLR_CUSTO_MD, 0) AS VLR_CUSTO_MEDIO
			,FP_FUNC.CD_CARGO AS CD_CARGO
			,ISNULL(IT.VLR_CUSTO_GERENCIAL_TRANSF, 0) AS VLR_CUSTO_GER
			,((IT.VLR_TOT_IT - IT.VLR_DESC_IT) * (IT.ALIQ_ICMS / 100)) AS VLR_ICMS_VENDA
			,0 AS CD_CLI_PBM
			,'' AS NR_AUTORIZACAO
			,CONVERT(MONEY, 0) AS VLR_REEMBOL
			,CONVERT(VARCHAR(250), '') AS RZ_CLI_PBM
			,VD.CD_CLI AS CD_CLI
			,RC_CLI.RZ_CLI AS RZ_CLI
			,0 AS CD_CONV
			,'NAO DENIFIDO' AS DS_CONV
			,CONVERT(TIME, VD.HR_EMI_NF) AS HR_VD
			,'NAO' AS VD_PBM
			,'NAO DEFINIDO' AS TIPO_OFERTA
			,0 AS CD_CTR_TBL
			,0 AS PERC_DESC_KIT_OFERTA
			,C.CD_SIGLA
			,C.TP_PROD
			,0 PERC_COMISSAO_SERVICO
			,IT.PIS_COFINS AS PIS_COFINS
			,ISNULL(PAGDP.ADQUIRENTE, '') AS MKTPLACE
		--INTO   #TBL_VD  
		FROM #PDV_VD_G TT
		INNER JOIN EST_NF_SAI VD ON VD.CD_EMP = TT.CD_EMP
			AND VD.CD_FILIAL = TT.CD_FILIAL
			AND VD.CD_NF = TT.CD_VD
		INNER JOIN EST_NF_SAI_IT IT ON VD.CD_EMP = IT.CD_EMP
			AND VD.CD_FILIAL = IT.CD_FILIAL
			AND VD.DT_EMI_NF = IT.DT_EMI_NF
			AND VD.CD_NF = IT.CD_NF
		INNER JOIN EST_TRIB T ON IT.CD_TRIB = T.CD_TRIB
		INNER JOIN #TBL_PROD_CPL C ON IT.CD_EMP = C.CD_EMP
			AND IT.CD_FILIAL = C.CD_FILIAL
			AND IT.CD_PROD = C.CD_PROD
		INNER JOIN #PRC_FILIAL F ON VD.CD_EMP = F.CD_EMP
			AND VD.CD_FILIAL = F.CD_FILIAL
		LEFT OUTER JOIN FP_FUNC ON VD.CD_EMP = FP_FUNC.CD_EMP
			AND VD.CD_VEND = FP_FUNC.CD_FUN
		LEFT OUTER JOIN FP_CARGO ON FP_FUNC.CD_EMP = FP_CARGO.CD_EMP
			AND FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
		INNER JOIN RC_CLI ON RC_CLI.CD_EMP = VD.CD_EMP
			AND RC_CLI.CD_CLI = VD.CD_CLI
		LEFT JOIN (
			SELECT DISTINCT RF.CD_EMP
				,RF.CD_CLI
			FROM RC_CLI_FIDELI_CARTAO RF
			) RF ON RC_CLI.CD_EMP = RF.CD_EMP
			AND RC_CLI.CD_CLI = RF.CD_CLI
		--------- add para pegar o adiquirente do marketplace ----------
		LEFT JOIN EST_NF_SAI_PED_VD PEDVD ON PEDVD.CD_EMP = VD.CD_EMP
			AND PEDVD.CD_FILIAL = VD.CD_FILIAL
			AND PEDVD.CD_NF = VD.CD_NF
		LEFT JOIN (
			SELECT DISTINCT CD_EMP
				,CD_FILIAL
				,CD_PED
				,MAX(CD_CTR) AS CD_CTR
			FROM EST_PED_VD_PAG
			GROUP BY CD_EMP
				,CD_FILIAL
				,CD_PED
			) PAG ON PAG.CD_EMP = PEDVD.CD_EMP
			AND PAG.CD_FILIAL = PEDVD.CD_FILIAL
			AND PAG.CD_PED = PEDVD.CD_PED
		LEFT JOIN EST_PED_VD_PAG_DUPLICATA PAGDP ON PAGDP.CD_EMP = PAG.CD_EMP
			AND PAGDP.PAG_CD_CTR = PAG.CD_CTR
		----------------------- fim -----------------------------------------
		WHERE IT.CD_EMP = 1
			AND IT.DT_EMI_NF BETWEEN @DT_INI
				AND @DT_FIM;
	END;

	/*********************************************************************************************************************************/
	--CREATE INDEX #IX__#TBL_VD_CD_PROD  
	-- ON #TBL_VD (CD_PROD, CD_FILIAL, CD_EMP);  
	-----------------------------------------------------------------------------  
	UPDATE V
	SET TIPO_PRODUTO = 'SERVICO'
		,VLR_PMC = V.TOT_IT
		,VLR_DESC_OFERTA = 0
		,VLR_CUSTO = V.TOT_IT - (V.TOT_IT * (V.PERC_COMISSAO_SERVICO / 100))
		,VLR_MARGEM_BRUTA = V.TOT_IT * (V.PERC_COMISSAO_SERVICO / 100)
	FROM #TBL_VD V
	WHERE V.CD_EMP = 1
		AND V.TP_PROD IN (
			10
			,11
			);

	-----------------------------------------------------------------------------  
	CREATE NONCLUSTERED INDEX [IX_#TBL_PROD_CPL_CD_SIGLA] ON [DBO].#TBL_VD (
		[CD_EMP]
		,[CD_SIGLA]
		);

	-----------------------------------------------------------------------------  
	/*  
 UPDATE V   
  SET DS_SIGLA = CASE WHEN CD_SIGLA =5 THEN 'AA'  
         WHEN CD_SIGLA =1 THEN 'A'  
         WHEN CD_SIGLA =2 THEN 'B'  
         WHEN CD_SIGLA =3 THEN 'C'  
         ELSE 'D' END  
 FROM     
  #TBL_VD V    
 WHERE  
  V.CD_EMP = 1 ;  
  */
	UPDATE V
	SET DS_SIGLA = 'B'
	FROM #TBL_VD V
	WHERE V.CD_EMP = 1
		AND V.CD_SIGLA = 2;

	UPDATE V
	SET DS_SIGLA = 'C'
	FROM #TBL_VD V
	WHERE V.CD_EMP = 1
		AND V.CD_SIGLA = 3;

	UPDATE V
	SET DS_SIGLA = 'AA'
	FROM #TBL_VD V
	WHERE V.CD_EMP = 1
		AND V.CD_SIGLA = 5;

	UPDATE V
	SET DS_SIGLA = 'A'
	FROM #TBL_VD V
	WHERE V.CD_EMP = 1
		AND V.CD_SIGLA = 1;

	----------------------------------------------------------------------------------------------------------------------------------------------------------  
	UPDATE V
	SET CD_CLI_PBM = PBM.CD_CLI_PBM
		,NR_AUTORIZACAO = PBM.NR_AUTORIZACAO
		,VLR_REEMBOL = ISNULL(PBM.VLR_REEMBOL, 0)
		,RZ_CLI_PBM = CLI_PBM.RZ_CLI
		,VD_PBM = 'SIM'
	FROM #TBL_VD V
	JOIN PDV_VD_IT_VD_PBM PBM ON PBM.CD_EMP = V.CD_EMP
		AND PBM.CD_FILIAL = V.CD_FILIAL
		AND PBM.CD_VD = V.CD_VD
		AND PBM.CD_IT = V.CD_IT
	JOIN RC_CLI CLI_PBM ON CLI_PBM.CD_EMP = PBM.CD_EMP
		AND CLI_PBM.CD_CLI = PBM.CD_CLI_PBM;

	UPDATE V
	SET V.VLR_CUSTO = MOV_I.VLR_CUSTO_GER * QT_IT
	FROM #TBL_VD V
	INNER JOIN EST_MOVIMENTO_VENDAS_RSVENDASITENS MOV_I ON V.CD_EMP = MOV_I.CD_EMP
		AND V.CD_FILIAL = MOV_I.CD_FILIAL
		AND V.CD_VD = MOV_I.CD_VD
		AND MOV_I.CD_PROD = V.CD_PROD
	WHERE V.VLR_CUSTO <= 0

	IF @DEVOLUCAO < 2
	BEGIN
		SELECT V.CD_FILIAL
			,BAIRRO
			,DT_VD
			,TIPO_PRODUTO
			,NR_ECF
			,CD_CX
			,VD_FIDEL
			,CD_VEND
			,NM_FUN
			,CARGO
			,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
			,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
			,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
			,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
			,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
			,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
			,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
			,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
			,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
			,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
			,V.PERC_COMIS
			,VL_COMIS
			,V.CD_PROD
			,DS_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_PROD
			,MATRIC
			,VLR_PMC
			,CD_TRIB_FC
			,CASE 
				WHEN TIPO_PRODUTO <> 'SERVICO'
					THEN TX_ICMS_IT
				ELSE CAST(0 AS MONEY)
				END TX_ICMS_IT
			,CASE 
				WHEN TIPO_PRODUTO = 'SERVICO'
					THEN TX_ICMS_IT
				ELSE CAST(0 AS MONEY)
				END TX_ISS_IT
			,VLR_DESC_ITENS
			,VLR_DESC
			,QT_IT
			,VLR_LIQ_VD
			,VLR_VD
			,VLR_DESC_OFERTA
			,ORIG_VENDA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS ORIG_VENDA
			,QT_VENDAS
			,VLR_DESC_VERBA
			,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
			,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
			,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
			,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
			,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
			,CASE 
				WHEN A.FLAG_PRODUTO_GENERICO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
			,V.LISTA_PROD
			,CASE 
				WHEN V.PIS_COFINS = 0
					THEN 'NAO'
				WHEN V.PIS_COFINS = 1
					THEN 'SIM'
				END COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
			,CASE 
				WHEN A.FLAG_PRODUTO_CONTROLADO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
			,CASE 
				WHEN A.COMPRA_POR_SUPRIMENTO = 0
					THEN '0 - RESSUPRIMENTO'
				WHEN A.COMPRA_POR_SUPRIMENTO = 1
					THEN '1 - SUPRIMENTO'
				ELSE '2 - SUP-RESSUP'
				END COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_COMPRA
			,A.DS_MC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_MC
			,VLR_CUSTO
			,VLR_MARGEM_BRUTA
			,PERC_COMI
			,VLR_COMI
			,SIT_VD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS SIT_VD
			,CASE 
				WHEN TIPO_PRODUTO <> 'SERVICO'
					THEN VLR_ICMS_VENDA
				ELSE CAST(0 AS MONEY)
				END AS VLR_ICMS_VENDA
			,CASE 
				WHEN TIPO_PRODUTO = 'SERVICO'
					THEN VLR_ICMS_VENDA
				ELSE CAST(0 AS MONEY)
				END AS VLR_ISS_VENDA
			,ISNULL(V.CD_CLI_PBM, '') AS CD_CLI_PBM
			,ISNULL(V.NR_AUTORIZACAO, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
			,ISNULL(V.VLR_REEMBOL, 0) AS VLR_REEMBOL
			,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
			,ISNULL(V.CD_CLI, 0) AS CD_CLI
			,ISNULL(V.RZ_CLI, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI
			,ISNULL(V.CD_CONV, 0) AS CD_CONV
			,ISNULL(V.DS_CONV, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_CONV
			--,CONVERT(VARCHAR(10), V.HR_VD, 108) AS HR_VD  
			,CONVERT(TIME, V.HR_VD) AS HR_VD
			,A.NR_NCM
			,V.VD_PBM
			,V.TIPO_OFERTA
			,V.CD_CTR_TBL
			,V.PERC_DESC_KIT_OFERTA
			,V.MKTPLACE
		INTO #TBL_VENDA
		FROM #TBL_VD V
		INNER JOIN #TBL_ARV A ON V.CD_EMP = A.CD_EMP
			AND V.CD_PROD = A.CD_PROD
	END

	/*************************************************************************************************************************************************/
	IF @DEVOLUCAO > 0
	BEGIN
		SELECT PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
			,F.BAIRRO
			,PDV_VD_DEV_EST_PROD_IMP.DT_DEVO AS DT_VD
			,CASE 
				WHEN EST_PROD_CPL.TP_PROD = 10
					THEN 'SERVICO'
				ELSE 'REVENDA'
				END AS TIPO_PRODUTO
			,PDV_VD.NR_ECF
			,PDV_VD.CD_CX
			,CASE 
				WHEN (
						SELECT TOP 1 NR_CARTAO
						FROM RC_CLI_FIDELI_CARTAO
						WHERE RC_CLI_FIDELI_CARTAO.CD_EMP = PDV_VD.CD_EMP
							AND RC_CLI_FIDELI_CARTAO.CD_CLI = PDV_VD.CD_CLI
						) IS NULL
					THEN 'SEM CARTO FIDELIDADE'
				ELSE 'CARTO FIDELIDADE'
				END VD_FIDEL
			,PDV_VD_DEV_EST_PROD_IMP.CD_VEND
			,NM_FUN
			,ISNULL(FP_CARGO.DS_CARGO, '') AS CARGO
			,DS_ARV_MERC_LINHA
			,DS_ARV_MERC_FAMILIA
			,DS_ARV_MERC_MIX
			,DS_ARV_MERC_MTZ_BCG
			,DS_ARV_MERC_PAPEL
			,DS_ARV_MERC_EQUI
			,DS_ARV_MERC_CONSUMO
			,DS_ARV_MERC_CLASSIFICACAO
			,DS_APRES
			,NM_FABRIC
			,(((PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * PDV_VD_DEV_EST_PROD_IMP.PERC_COMIS) / 100) * @MULTIPLO AS VL_COMIS
			,PDV_VD_DEV_EST_PROD_IMP.PERC_COMIS
			,A.CD_PROD
			,A.DS_PROD
			,FP_FUNC.MATRIC
			,(PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * @MULTIPLO AS VLR_PMC
			,'' AS CD_TRIB_FC
			,CAST(ISNULL(EST_NF_ENT_IT.ALIQ_ICMS, 0) AS MONEY) AS TX_ICMS_IT
			,CAST(0 AS MONEY) AS TX_ISS_IT
			,(((PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT)) - PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_VERBA) * @MULTIPLO AS VLR_DESC_ITENS
			,CAST(0 AS MONEY) AS VLR_DESC
			,PDV_VD_DEV_EST_PROD_IMP.QT_IT * @MULTIPLO AS QT_IT
			,(PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * @MULTIPLO AS VLR_LIQ_VD
			,(PDV_VD_DEV_EST_PROD_IMP.VLR_IT_BRUTO * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * @MULTIPLO AS VLR_VD
			,(
				CASE 
					WHEN PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT > PDV_VD_DEV_EST_PROD_IMP.VLR_IT_BRUTO
						THEN (PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT - PDV_VD_DEV_EST_PROD_IMP.VLR_IT_BRUTO) * PDV_VD_DEV_EST_PROD_IMP.QT_IT
					ELSE 0
					END
				) * CASE 
				WHEN @DEVOLUCAO = 1
					THEN - 1
				ELSE 1
				END AS VLR_DESC_OFERTA
			,CONVERT(VARCHAR(25), CASE 
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 0
						THEN 'DEV. DIRETO P.D.V'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 1
						THEN 'DEV. BALCAO'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 2
						THEN 'DEV. TELEVENDAS'
					ELSE 'NAO DEFINIDO'
					END) AS ORIG_VENDA
			,CAST(0 AS MONEY) AS QT_VENDAS
			,ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_VERBA, 0) * @MULTIPLO AS VLR_DESC_VERBA
			,DS_SIGLA
			,A.DS_ARV_MERC_CATEG
			,A.DS_ARV_MERC_DEPTO
			,A.DS_ARV_MERC_AREA_ATEND
			,CONVERT(VARCHAR(25), CASE 
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 0
						THEN 'DEV. DIRETO P.D.V'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 1
						THEN 'DEV. BALCAO'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 2
						THEN 'DEV. TELEVENDAS'
					ELSE 'NAO DEFINIDO'
					END) AS DS_TIPO_DESCONTO
			,CASE 
				WHEN A.FLAG_PRODUTO_GENERICO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END AS PRODGENERICO
			,CASE 
				WHEN A.LISTA_PROD = 0
					THEN 'POSITIVA'
				WHEN A.LISTA_PROD = 1
					THEN 'NEGATIVA'
				WHEN A.LISTA_PROD = 2
					THEN 'NEUTRA'
				ELSE 'NAO USA LISTA'
				END AS LISTA_PROD
			,CASE 
				WHEN EST_NF_ENT_IT.PIS_COFINS = 0
					THEN 'NAO'
				WHEN EST_NF_ENT_IT.PIS_COFINS = 1
					THEN 'SIM'
				END AS PIS_COFINS
			,CASE 
				WHEN A.FLAG_PRODUTO_CONTROLADO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END AS FLAG_PRODUTO_CONTROLADO
			,CASE 
				WHEN A.COMPRA_POR_SUPRIMENTO = 0
					THEN '0 - RESSUPRIMENTO'
				WHEN A.COMPRA_POR_SUPRIMENTO = 1
					THEN '1 - SUPRIMENTO'
				ELSE '2 - SUP-RESSUP'
				END TIPO_COMPRA
			,A.DS_MC
			,(
				PDV_VD_DEV_EST_PROD_IMP.QT_IT * CASE 
					WHEN @TP_CUSTO = 0
						THEN PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO
					ELSE PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO_MEDIO
					END
				) * @MULTIPLO AS VLR_CUSTO
			,(
				CASE 
					WHEN EST_PROD_CPL.TP_PROD IN (
							10
							,11
							)
						THEN ((PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
					ELSE (
							(PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) - (
								PDV_VD_DEV_EST_PROD_IMP.QT_IT * CASE 
									WHEN @TP_CUSTO = 0
										THEN PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO
									ELSE PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO_MEDIO
									END
								)
							)
					END
				) * @MULTIPLO AS VLR_MARGEM_BRUTA
			,CAST(0 AS MONEY) AS PERC_COMI
			,CAST(0 AS MONEY) AS VLR_COMI
			,CONVERT(VARCHAR(25), CASE 
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 0
						THEN 'DEV. DIRETO P.D.V'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 1
						THEN 'DEV. BALCAO'
					WHEN PDV_VD_DEV_EST_PROD_IMP.CD_ORIG_VENDA = 2
						THEN 'DEV. TELEVENDAS'
					ELSE 'NAO DEFINIDO'
					END) AS SIT_VD
			,EST_NF_ENT_IT.ALIQ_ICMS AS PERC_ICMS
			,((PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * (EST_NF_ENT_IT.ALIQ_ICMS / 100)) * @MULTIPLO AS VLR_ICMS_VENDA_DEVO
			,'' AS CD_CLI_PBM
			,'' AS NR_AUTORIZACAO
			,0 AS VLR_REEMBOL
			,'' AS RZ_CLI_PBM
			,ISNULL(PDV_VD.CD_CLI, 0) AS CD_CLI
			,ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI
			,ISNULL(PDV_VD.CD_CONV, 0) AS CD_CONV
			,ISNULL(RC_CLI_CONV.DS_CONV, '') AS DS_CONV
			--,CONVERT(VARCHAR(10), PDV_VD.HR_VD, 108)                                                                                            AS HR_VD  
			,CONVERT(TIME, PDV_VD.HR_VD) AS HR_VD
			,A.NR_NCM
			,CASE 
				WHEN ISNULL(PBM.CD_EMP, 0) = 0
					THEN 'NAO'
				ELSE 'SIM'
				END VD_PBM
			,CASE COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.TIPO_OFERTA, - 1)
				WHEN 0
					THEN 'DESCONTO POR QUANTIDADE'
				WHEN 1
					THEN 'LEVE X PAGUE Y'
				WHEN 2
					THEN 'LEVE X E GANHE Y'
				ELSE 'NAO DEFINIDO'
				END AS TIPO_OFERTA
			,COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.CD_CTR_TBL, 0) AS CD_CTR_TBL
			,COALESCE(V_PDV_VD_IT_DESC_KIT_OFERTA.PERC_DESC, 0) AS PERC_DESC_KIT_OFERTA
			,CAST('' AS VARCHAR(50)) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS MKTPLACE
		INTO #TBL_DEVO
		FROM PDV_VD_DEV_EST_PROD_IMP
		INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD
		LEFT JOIN V_PDV_VD_IT_DESC_KIT_OFERTA ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_VD
			AND PDV_VD_DEV_EST_PROD_IMP.CD_IT = V_PDV_VD_IT_DESC_KIT_OFERTA.CD_IT
		LEFT JOIN PDV_VD_IT_VD_PBM PBM ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PBM.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PBM.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PBM.CD_VD
			AND PDV_VD_DEV_EST_PROD_IMP.CD_IT = PBM.CD_IT
		INNER JOIN #PRC_FILIAL F ON PDV_VD.CD_EMP = F.CD_EMP
			AND PDV_VD.CD_FILIAL = F.CD_FILIAL
		INNER JOIN #TBL_PROD_CPL EST_PROD_CPL ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD_CPL.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD_CPL.CD_PROD
		INNER JOIN EST_PROD_CURVA_SIGLA ON EST_PROD_CPL.CD_EMP = EST_PROD_CURVA_SIGLA.CD_EMP
			AND EST_PROD_CPL.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA
		INNER JOIN FP_FUNC ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = FP_FUNC.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_VEND = FP_FUNC.CD_FUN
		INNER JOIN FP_CARGO ON FP_FUNC.CD_EMP = FP_CARGO.CD_EMP
			AND FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
		INNER JOIN #TBL_ARV A ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = A.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = A.CD_PROD
		LEFT OUTER JOIN PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
			AND PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP
		INNER JOIN RC_CLI ON RC_CLI.CD_EMP = PDV_VD.CD_EMP
			AND RC_CLI.CD_CLI = PDV_VD.CD_CLI
		LEFT JOIN RC_CLI_CONV ON PDV_VD.CD_EMP = RC_CLI_CONV.CD_EMP
			AND PDV_VD.CD_CONV = RC_CLI_CONV.CD_CONV
		LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT ENT ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = ENT.CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = ENT.CD_FILIAL
			AND PDV_VD_DEV_EST_PROD_IMP.CD_IMP = ENT.CD_IMP
			AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = ENT.CD_PROD
			AND PDV_VD_DEV_EST_PROD_IMP.CD_IT = ENT.CD_IT
		LEFT JOIN EST_NF_ENT_IT ON ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
			AND ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			AND ENT.CD_NF = EST_NF_ENT_IT.CD_NF
			AND ENT.CD_PROD = EST_NF_ENT_IT.CD_PROD
		--INNER JOIN EST_TRIB ON EST_NF_ENT_IT.CD_TRIB = EST_TRIB.CD_TRIB  
		WHERE PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
			AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO BETWEEN @DT_INI
				AND @DT_FIM;

		--------------------------------------------------------------------------------------------------------------  
		INSERT INTO #TBL_DEVO
		SELECT DEV.CD_FILIAL
			,F.BAIRRO
			,DEV.DT_DEVO AS DT_VD
			,CASE 
				WHEN EST_PROD_CPL.TP_PROD = 10
					THEN 'SERVICO'
				ELSE 'REVENDA'
				END AS TIPO_PRODUTO
			,DEV.NF_NF NR_ECF
			,0 CD_CX
			,CASE 
				WHEN (
						SELECT TOP 1 NR_CARTAO
						FROM RC_CLI_FIDELI_CARTAO
						WHERE RC_CLI_FIDELI_CARTAO.CD_EMP = DEV.CD_EMP
							AND RC_CLI_FIDELI_CARTAO.CD_CLI = DEV.CD_CLI
						) IS NULL
					THEN 'SEM CARTO FIDELIDADE'
				ELSE 'CARTO FIDELIDADE'
				END VD_FIDEL
			,DEV.CD_VEND
			,NM_FUN
			,ISNULL(FP_CARGO.DS_CARGO, '') AS CARGO
			,DS_ARV_MERC_LINHA
			,DS_ARV_MERC_FAMILIA
			,DS_ARV_MERC_MIX
			,DS_ARV_MERC_MTZ_BCG
			,DS_ARV_MERC_PAPEL
			,DS_ARV_MERC_EQUI
			,DS_ARV_MERC_CONSUMO
			,DS_ARV_MERC_CLASSIFICACAO
			,DS_APRES
			,NM_FABRIC
			,(DEV.VLR_TOT_IT) * (DEV.PERC_COMI / 100) * @MULTIPLO AS VL_COMIS
			,DEV.PERC_COMI
			,A.CD_PROD
			,A.DS_PROD
			,FP_FUNC.MATRIC
			,(DEV.VLR_IT * DEV.QT_IT) * @MULTIPLO AS VLR_PMC
			,'' AS CD_TRIB_FC
			,CAST(ISNULL(DEV.PERC_ICMS, 0) AS MONEY) AS TX_ICMS_IT
			,CAST(0 AS MONEY) AS TX_ISS_IT
			,(((DEV.VLR_DESC_IT)) - DEV.VLR_DESC_VERBA) * @MULTIPLO AS VLR_DESC_ITENS
			,CAST(0 AS MONEY) AS VLR_DESC
			,DEV.QT_IT * @MULTIPLO AS QT_IT
			,(DEV.VLR_TOT_IT) * @MULTIPLO AS VLR_LIQ_VD
			,(DEV.VLR_IT * DEV.QT_IT) * @MULTIPLO AS VLR_VD
			,(
				CASE 
					WHEN DEV.VLR_PMC_IT > DEV.VLR_IT_BRUTO
						THEN (DEV.VLR_PMC_IT - DEV.VLR_IT_BRUTO) * DEV.QT_IT
					ELSE 0
					END
				) * CASE 
				WHEN @DEVOLUCAO = 1
					THEN - 1
				ELSE 1
				END AS VLR_DESC_OFERTA
			,'DEV. NOTA FISCAL VENDA' AS ORIG_VENDA
			,CAST(0 AS MONEY) AS QT_VENDAS
			,ISNULL(DEV.VLR_DESC_VERBA, 0) * @MULTIPLO AS VLR_DESC_VERBA
			,DS_SIGLA
			,A.DS_ARV_MERC_CATEG
			,A.DS_ARV_MERC_DEPTO
			,A.DS_ARV_MERC_AREA_ATEND
			,'DEV. NOTA FISCAL VENDA' AS DS_TIPO_DESCONTO
			,CASE 
				WHEN A.FLAG_PRODUTO_GENERICO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END AS PRODGENERICO
			,CASE 
				WHEN A.LISTA_PROD = 0
					THEN 'POSITIVA'
				WHEN A.LISTA_PROD = 1
					THEN 'NEGATIVA'
				WHEN A.LISTA_PROD = 2
					THEN 'NEUTRA'
				ELSE 'NAO USA LISTA'
				END AS LISTA_PROD
			,CASE 
				WHEN DEV.PIS_COFINS = 0
					THEN 'NAO'
				WHEN DEV.PIS_COFINS = 1
					THEN 'SIM'
				END AS PIS_COFINS
			,CASE 
				WHEN A.FLAG_PRODUTO_CONTROLADO = 0
					THEN 'NAO'
				ELSE 'SIM'
				END AS FLAG_PRODUTO_CONTROLADO
			,CASE 
				WHEN A.COMPRA_POR_SUPRIMENTO = 0
					THEN '0 - RESSUPRIMENTO'
				WHEN A.COMPRA_POR_SUPRIMENTO = 1
					THEN '1 - SUPRIMENTO'
				ELSE '2 - SUP-RESSUP'
				END TIPO_COMPRA
			,A.DS_MC
			,(
				DEV.QT_IT * CASE 
					WHEN @TP_CUSTO = 0
						THEN DEV.VLR_CUSTO
					ELSE DEV.VLR_CUSTO_MEDIO
					END
				) * @MULTIPLO AS VLR_CUSTO
			,(
				CASE 
					WHEN EST_PROD_CPL.TP_PROD IN (
							10
							,11
							)
						THEN ((DEV.VLR_TOT_IT) * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
					ELSE (
							(DEV.VLR_TOT_IT) - (
								DEV.QT_IT * CASE 
									WHEN @TP_CUSTO = 0
										THEN DEV.VLR_CUSTO
									ELSE DEV.VLR_CUSTO_MEDIO
									END
								)
							)
					END
				) * @MULTIPLO AS VLR_MARGEM_BRUTA
			,CAST(0 AS MONEY) AS PERC_COMI
			,CAST(0 AS MONEY) AS VLR_COMI
			,'DEV. NOTA FISCAL VENDA' AS SIT_VD
			,DEV.PERC_ICMS
			,((DEV.VLR_TOT_IT) * (DEV.PERC_ICMS / 100)) * @MULTIPLO AS VLR_ICMS_VENDA_DEVO
			,'' AS CD_CLI_PBM
			,'' AS NR_AUTORIZACAO
			,0 AS VLR_REEMBOL
			,'' AS RZ_CLI_PBM
			,ISNULL(DEV.CD_CLI, 0) AS CD_CLI
			,ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI
			,0 AS CD_CONV
			,'' AS DS_CONV
			--,CONVERT(VARCHAR(10), DEV.HR_EMI_NF, 108)                     AS HR_VD  
			,CONVERT(TIME, DEV.HR_EMI_NF) AS HR_VD
			,A.NR_NCM
			,'NAO' AS VD_PBM
			,'NAO DEFINIDO' AS TIPO_OFERTA
			,0 AS CD_CTR_TBL
			,0 AS PERC_DESC_KIT_OFERTA
			,ISNULL(PAGDP.ADQUIRENTE, '') AS MKTPLACE								
		FROM V_EST_NF_SAI_VENDAS_DEVOLUCAO DEV
		INNER JOIN #PRC_FILIAL F ON DEV.CD_EMP = F.CD_EMP
			AND DEV.CD_FILIAL = F.CD_FILIAL
		INNER JOIN #TBL_PROD_CPL EST_PROD_CPL ON DEV.CD_EMP = EST_PROD_CPL.CD_EMP
			AND DEV.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
			AND DEV.CD_PROD = EST_PROD_CPL.CD_PROD
		INNER JOIN EST_PROD_CURVA_SIGLA ON EST_PROD_CPL.CD_EMP = EST_PROD_CURVA_SIGLA.CD_EMP
			AND EST_PROD_CPL.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA
		INNER JOIN FP_FUNC ON DEV.CD_EMP = FP_FUNC.CD_EMP
			AND DEV.CD_VEND = FP_FUNC.CD_FUN
		INNER JOIN FP_CARGO ON FP_FUNC.CD_EMP = FP_CARGO.CD_EMP
			AND FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
		INNER JOIN #TBL_ARV A ON DEV.CD_EMP = A.CD_EMP
			AND DEV.CD_PROD = A.CD_PROD
		INNER JOIN RC_CLI ON RC_CLI.CD_EMP = DEV.CD_EMP
			AND RC_CLI.CD_CLI = DEV.CD_CLI
		--------- add para pegar o adiquirente do marketplace ----------
		LEFT JOIN EST_NF_SAI_PED_VD PEDVD ON PEDVD.CD_EMP = dev.CD_EMP
			AND PEDVD.CD_FILIAL = DEV.CD_FILIAL
			AND PEDVD.CD_NF = DEV.CD_NF
		LEFT JOIN (
			SELECT DISTINCT CD_EMP
				,CD_FILIAL
				,CD_PED
				,MAX(CD_CTR) AS CD_CTR
			FROM EST_PED_VD_PAG
			GROUP BY CD_EMP
				,CD_FILIAL
				,CD_PED
			) PAG ON PAG.CD_EMP = PEDVD.CD_EMP
			AND PAG.CD_FILIAL = PEDVD.CD_FILIAL
			AND PAG.CD_PED = PEDVD.CD_PED
		LEFT JOIN EST_PED_VD_PAG_DUPLICATA PAGDP ON PAGDP.CD_EMP = PAG.CD_EMP
			AND PAGDP.PAG_CD_CTR = PAG.CD_CTR
		----------------------- fim -----------------------------------------
		WHERE DEV.CD_EMP = @CD_EMP
			AND DEV.DT_DEVO BETWEEN @DT_INI
				AND @DT_FIM
	END

	/*************************************************************************************************************************************************/
	IF @TP_RELA = 0
	BEGIN
		IF @DEVOLUCAO = 0
		BEGIN
			SELECT *
			FROM #TBL_VENDA
		END

		/*************************************************************************************************************************************************/
		IF @DEVOLUCAO = 1
		BEGIN
			SELECT CD_FILIAL
				,BAIRRO
				,DT_VD
				,TIPO_PRODUTO
				,NR_ECF
				,CD_CX
				,VD_FIDEL
				,CD_VEND
				,NM_FUN
				,CARGO
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,PERC_COMIS
				,VL_COMIS
				,CD_PROD
				,DS_PROD
				,MATRIC
				,VLR_PMC
				,CD_TRIB_FC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS CD_TRIB_FC
				,TX_ICMS_IT
				,TX_ISS_IT
				,VLR_DESC_ITENS
				,VLR_DESC
				,QT_IT
				,VLR_LIQ_VD
				,VLR_VD
				,VLR_DESC_OFERTA
				,ORIG_VENDA
				,QT_VENDAS
				,VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,VLR_CUSTO
				,VLR_MARGEM_BRUTA
				,PERC_COMI
				,VLR_COMI
				,SIT_VD
				,VLR_ICMS_VENDA
				,VLR_ISS_VENDA
				,VLR_MARGEM_BRUTA - ROUND(VLR_ICMS_VENDA, 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,ISNULL(CD_CLI_PBM, '') AS CD_CLI_PBM
				,ISNULL(NR_AUTORIZACAO, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
				,ISNULL(VLR_REEMBOL, 0) AS VLR_REEMBOL
				,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
				,ISNULL(CD_CLI, 0) AS CD_CLI
				,ISNULL(RZ_CLI, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI
				,ISNULL(CD_CONV, 0) AS CD_CONV
				,ISNULL(DS_CONV, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_CONV
				,ISNULL(HR_VD, '00:00') AS HR_VD
				,NR_NCM
				,VD_PBM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_PBM
				,TIPO_OFERTA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,CD_CTR_TBL
				,PERC_DESC_KIT_OFERTA
				,MKTPLACE
			FROM #TBL_VENDA
			
			UNION ALL
			
			SELECT CD_FILIAL
				,BAIRRO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS BAIRRO
				,DT_VD
				,TIPO_PRODUTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_PRODUTO
				,NR_ECF
				,CD_CX
				,VD_FIDEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_FIDEL
				,CD_VEND
				,NM_FUN COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FUN
				,CARGO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS CARGO
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,PERC_COMIS
				,VL_COMIS
				,CD_PROD
				,DS_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_PROD
				,MATRIC
				,VLR_PMC
				,'   ' COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS CD_TRIB_FC
				,TX_ICMS_IT
				,TX_ISS_IT
				,VLR_DESC_ITENS
				,VLR_DESC
				,QT_IT
				,VLR_LIQ_VD
				,VLR_VD
				,VLR_DESC_OFERTA
				,ORIG_VENDA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS ORIG_VENDA
				,QT_VENDAS
				,VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_COMPRA
				,DS_MC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_MC
				,VLR_CUSTO
				,VLR_MARGEM_BRUTA
				,PERC_COMI
				,VLR_COMI
				,SIT_VD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS SIT_VD
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN ROUND(VLR_ICMS_VENDA_DEVO, 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN ROUND(VLR_ICMS_VENDA_DEVO, 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
				,VLR_MARGEM_BRUTA - ROUND(VLR_ICMS_VENDA_DEVO, 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,CD_CLI_PBM
				,NR_AUTORIZACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
				,VLR_REEMBOL
				,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
				,ISNULL(CD_CLI, 0) AS CD_CLI
				,ISNULL(RZ_CLI, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI
				,ISNULL(CD_CONV, 0) AS CD_CONV
				,ISNULL(DS_CONV, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_CONV
				,ISNULL(HR_VD, '00:00') AS HR_VD
				,NR_NCM
				,VD_PBM
				,TIPO_OFERTA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,CD_CTR_TBL
				,PERC_DESC_KIT_OFERTA
				,ISNULL(MKTPLACE,'') AS MKTPLACE
			FROM #TBL_DEVO
		END

		IF @DEVOLUCAO = 2
		BEGIN
			SELECT *
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN ROUND(VLR_ICMS_VENDA_DEVO, 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN ROUND(VLR_ICMS_VENDA_DEVO, 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
			FROM #TBL_DEVO
		END
	END

	/*************************************************************************************************************************************************/
	IF @TP_RELA = 2
	BEGIN
		IF @DEVOLUCAO = 1
		BEGIN
			SELECT CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD) MES
				,TIPO_PRODUTO
				,VD_FIDEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_PROD
				,SUM(VLR_PMC) VLR_PMC
				,SUM(VLR_DESC_ITENS) VLR_DESC_ITENS
				,SUM(VLR_DESC) VLR_DESC
				,SUM(QT_IT) QT_IT
				,SUM(VLR_LIQ_VD) VLR_LIQ_VD
				,SUM(VLR_VD) VLR_VD
				,SUM(VLR_DESC_OFERTA) VLR_DESC_OFERTA
				,ORIG_VENDA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_COMPRA
				,DS_MC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS SIT_VD
				,ROUND(SUM(VLR_ICMS_VENDA), 2) AS VLR_ICMS_VENDA
				,ROUND(SUM(VLR_ISS_VENDA), 2) AS VLR_ISS_VENDA
				,TX_ICMS_IT
				,TX_ISS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,NR_NCM
				,VD_PBM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_PBM
				,MAX(TIPO_OFERTA) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) AS MKTPLACE
			FROM #TBL_VENDA
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,TX_ICMS_IT
				,TX_ISS_IT
				,NR_NCM
				,VD_PBM
			
			UNION ALL
			
			SELECT CD_FILIAL
				,BAIRRO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS BAIRRO
				,MONTH(DT_VD) AS MES
				,TIPO_PRODUTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_PRODUTO
				,VD_FIDEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_PROD
				,SUM(VLR_PMC) AS VLR_PMC
				,SUM(VLR_DESC_ITENS) AS VLR_DESC_ITENS
				,SUM(VLR_DESC) AS VLR_DESC
				,SUM(QT_IT) AS QT_IT
				,SUM(VLR_LIQ_VD) AS VLR_LIQ_VD
				,SUM(VLR_VD) AS VLR_VD
				,SUM(VLR_DESC_OFERTA) AS VLR_DESC_OFERTA
				,ORIG_VENDA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_COMPRA
				,DS_MC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS SIT_VD
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN PERC_ICMS
					ELSE CAST(0 AS MONEY)
					END TX_ICMS_IT
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN PERC_ICMS
					ELSE CAST(0 AS MONEY)
					END TX_ISS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,NR_NCM
				,VD_PBM
				,MAX(TIPO_OFERTA) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS MKTPLACE
			FROM #TBL_DEVO
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,PERC_ICMS
				,NR_NCM
				,VD_PBM
		END

		IF @DEVOLUCAO = 2
		BEGIN
			SELECT CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD) MES
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD
				,SUM(VLR_PMC) VLR_PMC
				,SUM(VLR_DESC_ITENS) VLR_DESC_ITENS
				,SUM(VLR_DESC) VLR_DESC
				,SUM(QT_IT) QT_IT
				,SUM(VLR_LIQ_VD) VLR_LIQ_VD
				,SUM(VLR_VD) VLR_VD
				,SUM(VLR_DESC_OFERTA) VLR_DESC_OFERTA
				,ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD
				,ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
				,PERC_ICMS AS TX_ICMS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,NR_NCM
				,VD_PBM
				,MAX(TIPO_OFERTA) AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS MKTPLACE
			FROM #TBL_DEVO
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,PERC_ICMS
				,NR_NCM
				,VD_PBM
		END
	END

	IF @TP_RELA = 3
	BEGIN
		IF @DEVOLUCAO = 1
		BEGIN
			SELECT CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD) MES
				,TIPO_PRODUTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_PRODUTO
				,VD_FIDEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_PROD
				,SUM(VLR_PMC) VLR_PMC
				,SUM(VLR_DESC_ITENS) VLR_DESC_ITENS
				,SUM(VLR_DESC) VLR_DESC
				,SUM(QT_IT) QT_IT
				,SUM(VLR_LIQ_VD) VLR_LIQ_VD
				,SUM(VLR_VD) VLR_VD
				,SUM(VLR_DESC_OFERTA) VLR_DESC_OFERTA
				,ORIG_VENDA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_COMPRA
				,DS_MC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS SIT_VD
				,ROUND(SUM(VLR_ICMS_VENDA), 2) AS VLR_ICMS_VENDA
				,ROUND(SUM(VLR_ISS_VENDA), 2) AS VLR_ISS_VENDA
				,TX_ICMS_IT
				,TX_ISS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,ISNULL(CD_CLI_PBM, '') AS CD_CLI_PBM
				,ISNULL(NR_AUTORIZACAO, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
				,ISNULL(VLR_REEMBOL, 0) AS VLR_REEMBOL
				,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
				,ISNULL(CD_CLI, 0) AS CD_CLI
				,ISNULL(RZ_CLI, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI
				,ISNULL(CD_CONV, 0) AS CD_CONV
				,ISNULL(DS_CONV, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_CONV
				,ISNULL(HR_VD, '00:00') AS HR_VD
				,NR_NCM
				,VD_PBM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS VD_PBM
				,MAX(TIPO_OFERTA) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) AS MKTPLACE
			FROM #TBL_VENDA
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,TX_ICMS_IT
				,TX_ISS_IT
				,CD_CLI_PBM
				,NR_AUTORIZACAO
				,VLR_REEMBOL
				,RZ_CLI_PBM
				,CD_CLI
				,RZ_CLI
				,CD_CONV
				,DS_CONV
				,HR_VD
				,NR_NCM
				,VD_PBM
			
			UNION ALL
			
			SELECT CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD) MES
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD
				,SUM(VLR_PMC) VLR_PMC
				,SUM(VLR_DESC_ITENS) VLR_DESC_ITENS
				,SUM(VLR_DESC) VLR_DESC
				,SUM(QT_IT) QT_IT
				,SUM(VLR_LIQ_VD) VLR_LIQ_VD
				,SUM(VLR_VD) VLR_VD
				,SUM(VLR_DESC_OFERTA) VLR_DESC_OFERTA
				,ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO <> 'SERVICO'
						THEN PERC_ICMS
					ELSE CAST(0 AS MONEY)
					END TX_ICMS_IT
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN PERC_ICMS
					ELSE CAST(0 AS MONEY)
					END TX_ISS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,CD_CLI_PBM
				,NR_AUTORIZACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
				,VLR_REEMBOL
				,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
				,ISNULL(CD_CLI, 0) AS CD_CLI
				,ISNULL(RZ_CLI, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI
				,ISNULL(CD_CONV, 0) AS CD_CONV
				,ISNULL(DS_CONV, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_CONV
				,ISNULL(HR_VD, '00:00') AS HR_VD
				,NR_NCM
				,VD_PBM
				,MAX(TIPO_OFERTA) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS MKTPLACE
			FROM #TBL_DEVO
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,PERC_ICMS
				,CD_CLI_PBM
				,NR_AUTORIZACAO
				,VLR_REEMBOL
				,RZ_CLI_PBM
				,CD_CLI
				,RZ_CLI
				,CD_CONV
				,DS_CONV
				,HR_VD
				,NR_NCM
				,VD_PBM
		END

		IF @DEVOLUCAO = 2
		BEGIN
			SELECT CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD) MES
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_APRES
				,NM_FABRIC COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NM_FABRIC
				,CD_PROD
				,DS_PROD
				,SUM(VLR_PMC) VLR_PMC
				,SUM(VLR_DESC_ITENS) VLR_DESC_ITENS
				,SUM(VLR_DESC) VLR_DESC
				,SUM(QT_IT) QT_IT
				,SUM(VLR_LIQ_VD) VLR_LIQ_VD
				,SUM(VLR_VD) VLR_VD
				,SUM(VLR_DESC_OFERTA) VLR_DESC_OFERTA
				,ORIG_VENDA
				,SUM(QT_VENDAS) QT_VENDAS
				,SUM(VLR_DESC_VERBA) VLR_DESC_VERBA
				,DS_SIGLA COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_SIGLA
				,DS_ARV_MERC_CATEG COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS DS_TIPO_DESCONTO
				,PRODGENERICO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS PRODGENERICO
				,LISTA_PROD COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SUM(VLR_CUSTO) VLR_CUSTO
				,SUM(VLR_MARGEM_BRUTA) VLR_MARGEM_BRUTA
				,SIT_VD
				,ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_ICMS_VENDA
				,CASE 
					WHEN TIPO_PRODUTO = 'SERVICO'
						THEN ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2)
					ELSE CAST(0 AS MONEY)
					END AS VLR_ISS_VENDA
				,PERC_ICMS AS TX_ICMS_IT
				,SUM(VLR_MARGEM_BRUTA) - ROUND(SUM(VLR_ICMS_VENDA_DEVO), 2) AS VLR_MARGEM_BRUTA_ABATENDO_ICMS_VENDA
				,CD_CLI_PBM
				,NR_AUTORIZACAO COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_AUTORIZACAO
				,VLR_REEMBOL
				,ISNULL(RZ_CLI_PBM, '') COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS RZ_CLI_PBM
				,ISNULL(CD_CLI, 0) AS CD_CLI
				,ISNULL(RZ_CLI, '') AS RZ_CLI
				,ISNULL(CD_CONV, 0) AS CD_CONV
				,ISNULL(DS_CONV, '') AS DS_CONV
				,ISNULL(HR_VD, '00:00') AS HR_VD
				,NR_NCM
				,VD_PBM
				,MAX(TIPO_OFERTA) AS TIPO_OFERTA
				,MAX(CD_CTR_TBL) AS CD_CTR_TBL
				,MAX(PERC_DESC_KIT_OFERTA) AS PERC_DESC_KIT_OFERTA
				,MAX(MKTPLACE) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS MKTPLACE
			FROM #TBL_DEVO
			GROUP BY CD_FILIAL
				,BAIRRO
				,MONTH(DT_VD)
				,TIPO_PRODUTO
				,VD_FIDEL
				,DS_ARV_MERC_LINHA
				,DS_ARV_MERC_FAMILIA
				,DS_ARV_MERC_MIX
				,DS_ARV_MERC_MTZ_BCG
				,DS_ARV_MERC_PAPEL
				,DS_ARV_MERC_EQUI
				,DS_ARV_MERC_CONSUMO
				,DS_ARV_MERC_CLASSIFICACAO
				,DS_APRES
				,NM_FABRIC
				,CD_PROD
				,DS_PROD
				,ORIG_VENDA
				,VLR_DESC_VERBA
				,DS_SIGLA
				,DS_ARV_MERC_CATEG
				,DS_ARV_MERC_DEPTO
				,DS_ARV_MERC_AREA_ATEND
				,DS_TIPO_DESCONTO
				,PRODGENERICO
				,LISTA_PROD
				,PIS_COFINS
				,FLAG_PRODUTO_CONTROLADO
				,TIPO_COMPRA
				,DS_MC
				,SIT_VD
				,PERC_ICMS
				,CD_CLI_PBM
				,NR_AUTORIZACAO
				,VLR_REEMBOL
				,RZ_CLI_PBM
				,CD_CLI
				,RZ_CLI
				,CD_CONV
				,DS_CONV
				,HR_VD
				,NR_NCM
				,VD_PBM
		END
	END
END
